<?php

class favouritesModule {
	private $registry;
	
	public function __construct($registry) {
		$this->registry = $registry;
	}
	
	public function add_to_favourites() {
		$this->registry->input->clean_array_gpc('p', array(
			'userid'	=> TYPE_INT,
			'fileid'	=> TYPE_INT
		));
		$xml = new vB_AJAX_XML_Builder($this->registry, 'text/xml');
		
		$userid = $this->registry->GPC['userid'];
		$fileid = $this->registry->GPC['fileid'];
		
		if (!$userid || !$fileid) {
			$xml->add_tag('error', $vbphrase['dbtech_downloads_ajax_request_failed']);
			
			$xml->print_xml();
			exit;
		}
		
		if (!empty($this->registry->userinfo['dbtech_downloads_favourites']) && count(unserialize($this->registry->userinfo['dbtech_downloads_favourites'])) > 0) {
			$favourites = unserialize($this->registry->userinfo['dbtech_downloads_favourites']);
		} else {
			$favourites = array();
		}
		if (in_array($fileid, $favourites)) {
			foreach ($favourites AS $i => $favour) {
				if ($favour == $fileid) {
					unset($favourites[$i]);
				}
			}
			
			$this->registry->db->query_write("
				UPDATE " . TABLE_PREFIX . "dbtech_downloads_filegroup
				SET
					favourites = favourites - 1
				WHERE groupid = $fileid	
			");
			
			$xml->add_group('downloads');
				$xml->add_tag('favourites', 'removed');
			$xml->close_group();
		} else {
			$favourites[] = $fileid;

			$this->registry->db->query_write("
				UPDATE " . TABLE_PREFIX . "dbtech_downloads_filegroup
				SET
					favourites = favourites + 1
				WHERE groupid = $fileid	
			");
			
			$xml->add_group('downloads');
				$xml->add_tag('favourites', 'added');
			$xml->close_group();
		}
		
		$this->registry->db->query_write("
			UPDATE " . TABLE_PREFIX . "user
			SET
				dbtech_downloads_favourites = '" . serialize($favourites) . "'
			WHERE userid = $userid
		");
		
		$xml->print_xml();
		exit;
	}
}

?>